/*
 * Decompiled with CFR 0.152.
 */
package com.github.monun.survival.tap.event;

import com.github.monun.survival.tap.event.EntityHandlerList;
import com.github.monun.survival.tap.event.EventEntity;
import com.github.monun.survival.tap.event.HandlerStatement;
import com.github.monun.survival.tap.event.ListenerStatement;
import com.github.monun.survival.tap.event.RegisteredEntityHandler;
import com.github.monun.survival.tap.event.RegisteredEntityListener;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\fJ\u0006\u0010\u0013\u001a\u00020\nR\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/github/monun/survival/tap/event/EventEntity;", "", "()V", "slots", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/lang/Class;", "Lcom/github/monun/survival/tap/event/EntityHandlerList;", "getHandlerList", "eventClass", "register", "", "registeredEntityListener", "Lcom/github/monun/survival/tap/event/RegisteredEntityListener;", "unregister", "statement", "Lcom/github/monun/survival/tap/event/ListenerStatement;", "listener", "Lorg/bukkit/event/Listener;", "registeredListener", "unregisterAll", "api"})
public final class EventEntity {
    private final ConcurrentHashMap<Class<?>, EntityHandlerList> slots = new ConcurrentHashMap();

    public final void register(@NotNull RegisteredEntityListener registeredEntityListener) {
        Intrinsics.checkNotNullParameter((Object)registeredEntityListener, (String)"registeredEntityListener");
        for (RegisteredEntityHandler handler : registeredEntityListener.getHandlers()) {
            EntityHandlerList handlerList2;
            HandlerStatement statement = handler.getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)this.slots.computeIfAbsent(statement.getRegistrationClass(), register.handlerList.1.INSTANCE), (String)"slots.computeIfAbsent(st\u2026) { EntityHandlerList() }");
            RegisteredEntityHandler registeredEntityHandler = handler;
            Intrinsics.checkNotNullExpressionValue((Object)registeredEntityHandler, (String)"handler");
            handlerList2.register(registeredEntityHandler);
        }
    }

    public final void unregister(@NotNull RegisteredEntityListener registeredListener) {
        Intrinsics.checkNotNullParameter((Object)registeredListener, (String)"registeredListener");
        for (RegisteredEntityHandler handler : registeredListener.getHandlers()) {
            EntityHandlerList handlerList2;
            handler.remove();
            EntityHandlerList entityHandlerList = handlerList2 = this.slots.get(handler.getStatement().getRegistrationClass());
            if (entityHandlerList == null) continue;
            RegisteredEntityHandler registeredEntityHandler = handler;
            Intrinsics.checkNotNullExpressionValue((Object)registeredEntityHandler, (String)"handler");
            entityHandlerList.unregister(registeredEntityHandler);
        }
    }

    public final void unregister(@NotNull ListenerStatement statement, @NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        for (HandlerStatement handlerStatement : statement.getHandlerStatements()) {
            EntityHandlerList handlerList2;
            EntityHandlerList entityHandlerList = handlerList2 = this.slots.get(handlerStatement.getRegistrationClass());
            if (entityHandlerList == null) continue;
            entityHandlerList.unregister(listener2);
        }
    }

    @Nullable
    public final EntityHandlerList getHandlerList(@NotNull Class<?> eventClass) {
        Intrinsics.checkNotNullParameter(eventClass, (String)"eventClass");
        return this.slots.get(eventClass);
    }

    public final void unregisterAll() {
        for (EntityHandlerList handlerList2 : this.slots.values()) {
            handlerList2.unregisterAll();
        }
        this.slots.clear();
    }
}

